/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.block.branch;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.OffsetablePodBlock;
import com.ferreusveritas.dynamictrees.block.branch.BasicBranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.AerialRootsSoilProperties;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.event.FutureBreak;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.RootsDestroyerNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.SpeciesNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.StateNode;
import com.ferreusveritas.dynamictrees.tree.family.MangroveFamily;
import com.ferreusveritas.dynamictrees.tree.species.MangroveSpecies;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.EntityUtils;
import com.ferreusveritas.dynamictrees.util.LootTableSupplier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;

public class BasicRootsBlock
extends BranchBlock
implements SimpleWaterloggedBlock {
    public static final String NAME_SUFFIX = "_roots";
    public static final IntegerProperty RADIUS = IntegerProperty.m_61631_((String)"radius", (int)1, (int)8);
    public static final EnumProperty<Layer> LAYER = EnumProperty.m_61587_((String)"layer", Layer.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private int flammability = 5;
    private int fireSpreadSpeed = 5;
    private final LootTableSupplier rootLootTableSupplier;

    public BasicRootsBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(name, properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(LAYER, (Comparable)((Object)Layer.EXPOSED)));
        this.rootLootTableSupplier = new LootTableSupplier("trees/roots/", name);
    }

    public boolean isFullBlock(BlockState state) {
        return state.m_61143_(LAYER) == Layer.COVERED;
    }

    @Override
    public MangroveFamily getFamily() {
        return (MangroveFamily)super.getFamily();
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        int radius = this.getRadius(level.m_8055_(pos));
        return this.fireSpreadSpeed * radius / 8;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.flammability;
    }

    public BasicRootsBlock setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public BasicRootsBlock setFireSpreadSpeed(int fireSpreadSpeed) {
        this.fireSpreadSpeed = fireSpreadSpeed;
        return this;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{RADIUS, LAYER, WATERLOGGED});
    }

    @Override
    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesProperties) {
        return CellNull.NULL_CELL;
    }

    @Override
    public int probabilityForBlock(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from) {
        return 10;
    }

    @Override
    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.getRadius(state);
    }

    @Override
    public int getRadius(BlockState state) {
        return (Integer)state.m_61143_((Property)RADIUS);
    }

    protected int getMaxSignalDepth() {
        return this.getFamily().getMaxSignalDepth();
    }

    @Override
    public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        if (branch instanceof BasicRootsBlock) {
            return this.isSameTree(branch) ? BasicBranchBlock.setSupport(1, 0) : 0;
        }
        return 0;
    }

    @Override
    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        Layer layer;
        boolean isFullBlock;
        destroyMode = DynamicTrees.DestroyMode.SET_RADIUS;
        BlockState currentState = level.m_8055_(pos);
        boolean replacingWater = currentState.m_60819_() == Fluids.f_76193_.m_76068_(false);
        boolean replacingGround = this.getFamily().isAcceptableSoilForRootSystem(currentState);
        boolean setWaterlogged = replacingWater && !replacingGround;
        boolean bl = isFullBlock = radius >= 8;
        if (currentState.m_60713_((Block)this)) {
            layer = (Layer)((Object)currentState.m_61143_(LAYER));
            if (layer == Layer.COVERED && isFullBlock) {
                layer = Layer.FILLED;
            }
        } else {
            layer = replacingGround ? Layer.COVERED : Layer.EXPOSED;
        }
        level.m_7731_(pos, (BlockState)((BlockState)this.getStateForRadius(radius).m_61124_(LAYER, (Comparable)((Object)layer))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(setWaterlogged)), flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        return radius;
    }

    @Override
    public BlockState getStateForRadius(int radius) {
        return (BlockState)this.m_49966_().m_61124_((Property)RADIUS, (Comparable)Integer.valueOf(radius));
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (this.isFullBlock(state) && this.getFamily().getPrimitiveCoveredRoots().isPresent()) {
            return new ItemStack((ItemLike)this.getFamily().getPrimitiveCoveredRoots().get());
        }
        return new ItemStack((ItemLike)this.m_5456_());
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @org.jetbrains.annotations.Nullable Entity entity) {
        Optional<Block> primitive = ((Layer)((Object)state.m_61143_(LAYER))).getPrimitive(this.getFamily());
        if (primitive.isPresent()) {
            return primitive.get().getSoundType(state, level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_6044_(BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        return !this.isFullBlock(pState) && (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) == false && pFluid == Fluids.f_76193_;
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (this.m_6044_((BlockGetter)pLevel, pPos, pState, pFluidState.m_76152_())) {
            if (!pLevel.m_5776_()) {
                pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true))).m_61124_(LAYER, (Comparable)((Object)Layer.EXPOSED)), 3);
                pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            }
            return true;
        }
        return false;
    }

    @Override
    public ResourceLocation getLootTableName() {
        return this.rootLootTableSupplier.getName();
    }

    @Override
    public LootTable getLootTable(LootDataManager lootTables, Species species) {
        return this.rootLootTableSupplier.get(lootTables, species);
    }

    @Override
    public Optional<Block> getPrimitiveLog() {
        return this.getFamily().getPrimitiveRoots();
    }

    protected boolean canPlace(Player player, Level level, BlockPos clickedPos, BlockState pState) {
        CollisionContext collisioncontext = player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player);
        return pState.m_60710_((LevelReader)level, clickedPos) && level.m_45752_(pState, clickedPos, collisioncontext);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!this.isFullBlock(state)) {
            Layer layer = Layer.COVERED;
            if ((Integer)state.m_61143_((Property)RADIUS) >= 8) {
                layer = state.m_61143_(LAYER) == Layer.EXPOSED ? Layer.FILLED : null;
            }
            if (layer != null) {
                BlockState newState;
                ItemStack handStack = player.m_21120_(hand);
                Block coverBlock = this.getFamily().getPrimitiveCoveredRoots().orElse(null);
                if (coverBlock != null && handStack.m_41720_() == coverBlock.m_5456_() && this.canPlace(player, level, pos, newState = (BlockState)((BlockState)state.m_61124_(LAYER, (Comparable)((Object)layer))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)))) {
                    level.m_7731_(pos, newState, 3);
                    if (!player.m_7500_()) {
                        handStack.m_41774_(1);
                    }
                    level.m_5594_(null, pos, coverBlock.getSoundType(state, (LevelReader)level, pos, (Entity)player).m_56777_(), SoundSource.BLOCKS, 1.0f, 0.8f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.isFullBlock(state)) {
            level.m_7731_(pos, (BlockState)state.m_61124_(LAYER, (Comparable)((Object)Layer.FILLED)), level.f_46443_ ? 11 : 3);
            this.m_142387_(level, player, pos, state);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            Block primitive = ((Layer)((Object)state.m_61143_(LAYER))).getPrimitive(this.getFamily()).orElse(null);
            if (!player.m_7500_() && primitive != null) {
                BasicRootsBlock.m_49950_((BlockState)primitive.m_49966_(), (Level)level, (BlockPos)pos);
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Override
    public boolean removedByEntity(BlockState state, Level level, BlockPos cutPos, LivingEntity entity) {
        Block block = level.m_8055_(cutPos.m_7494_()).m_60734_();
        if (block instanceof AerialRootsSoilProperties.RootRootyBlock) {
            AerialRootsSoilProperties.RootRootyBlock aerialRootyBlock = (AerialRootsSoilProperties.RootRootyBlock)block;
            aerialRootyBlock.dropWholeTree(level, cutPos.m_7494_(), entity instanceof Player ? (Player)entity : null);
        } else {
            FutureBreak.add(new FutureBreak(state, level, cutPos, entity, 0));
        }
        return false;
    }

    @Override
    public void futureBreak(BlockState state, Level level, BlockPos cutPos, LivingEntity entity) {
        double reachDistance = entity instanceof Player ? Objects.requireNonNull(entity.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get())).m_22135_() : 5.0;
        BlockHitResult ragTraceResult = EntityUtils.playerRayTrace(entity, reachDistance, 1.0f);
        Direction toolDir = ragTraceResult != null ? (entity.m_6144_() ? ragTraceResult.m_82434_().m_122424_() : ragTraceResult.m_82434_()) : Direction.DOWN;
        level.m_5898_(null, 2001, cutPos, BasicRootsBlock.m_49956_((BlockState)state));
        BranchDestructionData destroyData = this.destroyBranchFromNode(level, cutPos, toolDir, false, entity);
        ItemStack heldItem = entity.m_21205_();
        int fortune = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)heldItem);
        float fortuneFactor = 1.0f + 0.25f * (float)fortune;
        NetVolumeNode.Volume woodVolume = destroyData.woodVolume;
        woodVolume.multiplyVolume(fortuneFactor);
        List<ItemStack> woodItems = destroyData.species.getBranchesDrops(level, woodVolume, heldItem);
        FallingTreeEntity.dropTree(level, destroyData, woodItems, FallingTreeEntity.DestroyType.HARVEST);
        this.damageAxe(entity, heldItem, this.getRadius(state), woodVolume, true);
    }

    @Override
    public BranchDestructionData destroyBranchFromNode(Level level, BlockPos cutPos, Direction toolDir, boolean wholeTree, @Nullable LivingEntity entity) {
        BlockState blockState = level.m_8055_(cutPos);
        SpeciesNode speciesNode = new SpeciesNode();
        MapSignal signal = this.analyse(blockState, (LevelAccessor)level, cutPos, null, new MapSignal(speciesNode));
        Species species = speciesNode.getSpecies();
        StateNode stateMapper = new StateNode(cutPos);
        this.analyse(blockState, (LevelAccessor)level, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(stateMapper));
        NetVolumeNode volumeSum = new NetVolumeNode();
        RootsDestroyerNode destroyer = new RootsDestroyerNode(this.getFamily());
        destroyMode = DynamicTrees.DestroyMode.HARVEST;
        this.analyse(blockState, (LevelAccessor)level, cutPos, wholeTree ? null : signal.localRootDir, new MapSignal(volumeSum, destroyer));
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        int trunkHeight = 1;
        BlockPos iter = new BlockPos(0, 1, 0);
        while (stateMapper.getBranchConnectionMap().containsKey(iter)) {
            ++trunkHeight;
            iter = iter.m_7494_();
        }
        Direction cutDir = signal.localRootDir;
        if (cutDir == null) {
            cutDir = Direction.UP;
        }
        BlockPos lowestBlock = stateMapper.getBranchConnectionMap().keySet().stream().min(Comparator.comparingInt(Vec3i::m_123342_)).orElse(BlockPos.f_121853_);
        BlockPos.MutableBlockPos basePos = new BlockPos((Vec3i)cutPos).m_122032_();
        for (int i = 0; i > lowestBlock.m_123342_() && level.m_8055_(basePos.m_122184_(0, -1, 0).m_7495_()).m_247087_(); --i) {
        }
        if (signal.foundRoot) {
            this.DropTreeIfUnsupported(level, cutPos, signal.root, entity instanceof Player ? (Player)entity : null);
        }
        return new BranchDestructionData(species, stateMapper.getBranchConnectionMap(), new HashMap<BlockPos, BlockState>(), new ArrayList<BranchBlock.ItemStackPos>(), destroyer.getEnds(), volumeSum.getVolume(), cutPos, (BlockPos)basePos, cutDir, toolDir, trunkHeight);
    }

    private void DropTreeIfUnsupported(Level level, BlockPos cutPos, BlockPos rootPos, @org.jetbrains.annotations.Nullable Player player) {
        AerialRootsSoilProperties.RootRootyBlock rootyBlock;
        Block block = level.m_8055_(rootPos).m_60734_();
        if (block instanceof AerialRootsSoilProperties.RootRootyBlock && !(rootyBlock = (AerialRootsSoilProperties.RootRootyBlock)block).isStructurallyStable((LevelAccessor)level, rootPos)) {
            rootyBlock.dropWholeTree(level, rootPos, player);
        }
    }

    @Override
    public float getHardness(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.isFullBlock(state)) {
            return this.getFamily().getPrimitiveCoveredRoots().orElse(Blocks.f_50016_).m_155943_();
        }
        int radius = this.getRadius(level.m_8055_(pos));
        float hardness = this.getFamily().getPrimitiveLog().orElse(Blocks.f_50016_).m_49966_().m_60800_(level, pos) * ((Double)DTConfigs.TREE_HARDNESS_MULTIPLIER.get()).floatValue() * (float)(radius * radius) / 64.0f * 8.0f;
        return (float)Math.min((double)hardness, (Double)DTConfigs.MAX_TREE_HARDNESS.get());
    }

    @Override
    public BlockState getStateForDecay(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean waterlogged = state.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false;
        Layer layer = state.m_61138_(LAYER) ? (Layer)((Object)state.m_61143_(LAYER)) : Layer.EXPOSED;
        Block primitive = layer == Layer.COVERED && layer.getPrimitive(this.getFamily()).isPresent() ? layer.getPrimitive(this.getFamily()).get() : Blocks.f_50016_;
        return waterlogged ? Blocks.f_49990_.m_49966_() : primitive.m_49966_();
    }

    @Deprecated
    public float m_5880_(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        Optional<Block> covered = this.getFamily().getPrimitiveCoveredRoots();
        if (pState.m_61138_(LAYER) && pState.m_61143_(LAYER) == Layer.COVERED && covered.isPresent()) {
            return covered.get().m_5880_(covered.get().m_49966_(), pPlayer, pLevel, pPos);
        }
        return super.m_5880_(pState, pPlayer, pLevel, pPos);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        if (state.m_61143_(LAYER) == Layer.COVERED) {
            AtomicBoolean canSustain = new AtomicBoolean(false);
            Layer.COVERED.getPrimitive(this.getFamily()).ifPresent(block -> canSustain.set(block.canSustainPlant(block.m_49966_(), world, pos, facing, plantable)));
            return canSustain.get();
        }
        return super.canSustainPlant(state, world, pos, facing, plantable);
    }

    @Override
    public boolean checkForRot(LevelAccessor level, BlockPos pos, Species species, int fertility, int radius, RandomSource rand, float chance, boolean rapid) {
        if (!rapid && (chance == 0.0f || rand.m_188501_() > chance)) {
            return false;
        }
        if (this.isFullBlock(level.m_8055_(pos))) {
            return false;
        }
        int neigh = 0;
        for (Direction dir : Direction.values()) {
            BlockPos deltaPos = pos.m_121945_(dir);
            BlockState deltaBlockState = level.m_8055_(deltaPos);
            if (BasicRootsBlock.getBranchSupport(neigh += TreeHelper.getTreePart(deltaBlockState).branchSupport(deltaBlockState, (BlockGetter)level, this, deltaPos, dir, radius)) < 2) continue;
            return false;
        }
        boolean didRot = species.rot(level, pos, neigh & 0xF, radius, fertility, rand, true, false);
        if (rapid && didRot) {
            for (Direction dir : Direction.values()) {
                BlockPos neighPos = pos.m_121945_(dir);
                BlockState neighState = level.m_8055_(neighPos);
                if (neighState.m_60734_() != this) continue;
                this.checkForRot(level, neighPos, species, fertility, this.getRadius(neighState), rand, 1.0f, true);
            }
        }
        return didRot;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.isFullBlock(state)) {
            return Shapes.m_83144_();
        }
        return super.m_5940_(state, level, pos, context);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (this.isFullBlock(pState)) {
            VoxelShape fullShape = Shapes.m_83144_();
            if (this.getFamily().getPrimitiveCoveredRoots().isPresent()) {
                fullShape = this.getFamily().getPrimitiveCoveredRoots().get().m_5939_(pState, pLevel, pPos, pContext);
            }
            return fullShape;
        }
        return super.m_5939_(pState, pLevel, pPos, pContext);
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        if (BasicRootsBlock.isTransparent(pState)) {
            return Shapes.m_83040_();
        }
        return super.m_7952_(pState, pLevel, pPos);
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        if (BasicRootsBlock.isTransparent(pState)) {
            return Shapes.m_83040_();
        }
        return super.m_5909_(pState, pReader, pPos, pContext);
    }

    public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pSide) {
        return pAdjacentBlockState.m_60713_((Block)this) && ((Layer)((Object)pAdjacentBlockState.m_61143_(LAYER))).ordinal() >= ((Layer)((Object)pState.m_61143_(LAYER))).ordinal() || super.m_6104_(pState, pAdjacentBlockState, pSide);
    }

    public static boolean isTransparent(BlockState state) {
        return state.m_60734_() instanceof BasicRootsBlock && state.m_61143_(LAYER) == Layer.EXPOSED;
    }

    private boolean canGrowInto(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        boolean isFree = this.getFamily().isAcceptableSoilForRootSystem(state) || state.m_247087_();
        return isFree || state.m_60734_() instanceof BasicRootsBlock;
    }

    private boolean isNextToRooty(Level level, BlockPos pos, Direction originDir) {
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir) || !TreeHelper.isRooty(level.m_8055_(pos.m_121945_(dir)))) continue;
            return true;
        }
        return false;
    }

    public GrowSignal growIntoAir(Level level, BlockPos pos, GrowSignal signal, int fromRadius, boolean fromGround) {
        if (BasicRootsBlock.isNextToBranch(level, pos, signal.dir.m_122424_()) || this.isNextToRooty(level, pos, signal.dir.m_122424_())) {
            signal.success = false;
            return signal;
        }
        int supportExtraThickness = 0;
        int radius = this.getFamily().getPrimaryRootThickness() + supportExtraThickness;
        this.setRadius((LevelAccessor)level, pos, radius, null);
        signal.radius = this.getFamily().getSecondaryRootThickness() + supportExtraThickness;
        signal.success = true;
        return signal;
    }

    @Override
    public GrowSignal growSignal(Level level, BlockPos pos, GrowSignal signal) {
        Block deltaPos;
        if (!signal.step()) {
            return signal;
        }
        BlockState currBlockState = level.m_8055_(pos);
        Species species = signal.getSpecies();
        if (!(species instanceof MangroveSpecies)) {
            return signal;
        }
        MangroveSpecies speciesMangrove = (MangroveSpecies)species;
        Direction originDir = signal.dir.m_122424_();
        Direction targetDir = speciesMangrove.getRootsGrowthLogicKit().selectNewDirection(new DirectionSelectionContext(level, pos, species, this, signal));
        signal.doTurn(targetDir);
        BlockPos deltaPos2 = pos.m_121945_(targetDir);
        BlockState deltaState = level.m_8055_(deltaPos2);
        Direction[] treepart = TreeHelper.getTreePart(deltaState);
        if (treepart != TreeHelper.NULL_TREE_PART) {
            signal = treepart.growSignal(level, deltaPos2, signal);
        } else if (this.canGrowInto(level, deltaPos2)) {
            signal = this.growIntoAir(level, deltaPos2, signal, this.getRadius(currBlockState), this.isFullBlock(currBlockState));
        }
        float areaAccum = signal.radius * signal.radius;
        boolean theresPods = false;
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir) || dir.equals((Object)targetDir)) continue;
            deltaPos = pos.m_121945_(dir);
            BlockState blockState = level.m_8055_((BlockPos)deltaPos);
            TreePart treepart2 = TreeHelper.getTreePart(blockState);
            if (this.isSameTree(treepart2)) {
                int branchRadius = treepart2.getRadius(blockState);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            if (!(blockState.m_60734_() instanceof OffsetablePodBlock)) continue;
            theresPods = true;
        }
        if (!signal.choked) {
            int rootThickness = 8;
            BlockState rootState = level.m_8055_(signal.rootPos);
            deltaPos = rootState.m_60734_();
            if (deltaPos instanceof AerialRootsSoilProperties.RootRootyBlock) {
                AerialRootsSoilProperties.RootRootyBlock rootyRoot = (AerialRootsSoilProperties.RootRootyBlock)deltaPos;
                rootThickness = Math.min(rootyRoot.getRadius(rootState), 8);
            } else {
                RootyBlock rooty;
                Direction dir;
                BlockPos treePos;
                deltaPos = rootState.m_60734_();
                if (deltaPos instanceof RootyBlock && TreeHelper.isBranch(level.m_8055_(treePos = signal.rootPos.m_121945_(dir = (rooty = (RootyBlock)deltaPos).getTrunkDirection((BlockGetter)level, signal.rootPos))))) {
                    rootThickness = TreeHelper.getRadius((BlockGetter)level, treePos);
                }
            }
            int maxRadius = Math.min(8, Math.min(species.getMaxBranchRadius(), rootThickness));
            signal.radius = Mth.m_14036_((float)((float)Math.sqrt(areaAccum) + speciesMangrove.getRootTapering()), (float)this.getRadius(currBlockState), (float)maxRadius);
            int targetRadius = (int)Math.floor(signal.radius);
            int flags = theresPods ? 3 : 2;
            int setRad = this.setRadius((LevelAccessor)level, pos, targetRadius, originDir, flags);
            if (setRad < targetRadius) {
                signal.choked = true;
            }
        }
        return signal;
    }

    @Override
    public MapSignal analyse(BlockState blockState, LevelAccessor level, BlockPos pos, @Nullable Direction fromDir, MapSignal signal) {
        if (signal.overflow || signal.trackVisited && signal.doTrackingVisited(pos)) {
            return signal;
        }
        if (signal.depth++ < this.getMaxSignalDepth()) {
            signal.run(blockState, level, pos, fromDir);
            for (Direction dir : Direction.values()) {
                BlockPos deltaPos;
                BlockState deltaState;
                TreePart treePart;
                if (dir == fromDir || !(treePart = TreeHelper.getTreePart(deltaState = level.m_8055_(deltaPos = pos.m_121945_(dir)))).shouldAnalyse(deltaState, (BlockGetter)level, deltaPos)) continue;
                signal = treePart.analyse(deltaState, level, deltaPos, dir.m_122424_(), signal);
                if (!signal.foundRoot || signal.localRootDir != null || fromDir != null) continue;
                signal.localRootDir = dir;
            }
            signal.returnRun(blockState, level, pos, fromDir);
        } else {
            BlockState state = level.m_8055_(pos);
            if (signal.destroyLoopedNodes && state.m_60734_() instanceof BranchBlock) {
                BranchBlock branch = (BranchBlock)state.m_60734_();
                branch.breakDeliberate(level, pos, DynamicTrees.DestroyMode.OVERFLOW);
            }
            signal.overflow = true;
        }
        --signal.depth;
        return signal;
    }

    public static enum Layer implements StringRepresentable
    {
        EXPOSED(MangroveFamily::getPrimitiveRoots),
        FILLED(MangroveFamily::getPrimitiveFilledRoots),
        COVERED(MangroveFamily::getPrimitiveCoveredRoots);

        final Function<MangroveFamily, Optional<Block>> primitiveFunc;

        private Layer(Function<MangroveFamily, Optional<Block>> primitiveFunc) {
            this.primitiveFunc = primitiveFunc;
        }

        @NotNull
        public String m_7912_() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        public Optional<Block> getPrimitive(MangroveFamily family) {
            return this.primitiveFunc.apply(family);
        }
    }
}

